/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 2000 Adobe Systems Incorporated                       */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------------------

#ifndef __PIUGet_H__		// Has this not been defined yet?
#define __PIUGet_H__		// Only include this once by predefining it

#include "PITypes.h"
#if Macintosh
	#include <AEObjects.h>
#endif
#include "PIGeneral.h"
#include "SPBasic.h"
#include "PIActions.h"

extern PSActionDescriptorProcs* sPSActionDescriptor;
extern PSActionReferenceProcs* sPSActionReference;
extern PSActionListProcs* sPSActionList;
extern PSActionControlProcs* sPSActionControl;

SPErr PIUGetInfo(DescriptorClassID desiredClass,
				 DescriptorKeyID desiredKey,
				 void* returnData,
				 void* returnExtraData);
SPErr PIUGetInfoByIndex(uint32 index,
						DescriptorClassID desiredClass,
						DescriptorKeyID desiredKey,
						void* returnData,
						void* returnExtraData);
SPErr PIUGetInfoByIndexIndex(uint32 indexChild,
							 uint32 indexParent,
							 DescriptorClassID desiredClassChild,
							 DescriptorClassID desiredClassParent,
							 DescriptorKeyID desiredKey,
							 void* returnData,
							 void* returnExtraData);
SPErr PIUGetSingleItemFromDescriptor(PIActionDescriptor result, 
								     DescriptorKeyID desiredKey, 
								     void* returnData,
								     void* returnExtraData);
SPErr PIUGetErrorStringFromDescriptor(PIActionDescriptor descriptor,
								      char* stringPtr);

SPErr PIUGetBackgroundInfo(DescriptorKeyID desiredKey, 
						   void* returnData,
						   void* returnExtraData);
#endif
// end PIUGet.h
